<?php

namespace App\Http\Controllers;

use App\Models\Attribute;
use App\Models\MerchantSite;
use Illuminate\Http\Request;

class AttributeController extends Controller
{
    public function index()
    {
        $attributes =  Attribute::orderBy('id', 'DESC')->paginate();

        return view('attribute.index', ['attributes' => $attributes]);
    }

    public function create()
    {
        return view('attribute.create');
    }

    public function postCreate(Request $request)
    {
        $input = $request->all();

        $input['merchant_site_id'] = auth('web')->user()->id;

        $attributes = Attribute::create($input);
        
        if($attributes) {
            return redirect()->to('attribute/index')->withSuccess('Attribute create successfuly');
        }
        return redirect()->back('attribute/index')->withErrors('Attribute not create');  
    }

    public function edit($id)
    {
        $attributes = Attribute::find($id);

        return view( 'attribute.edit', ['attributes' => $attributes,
        ]);
    }

    public function update(Request $request)
    {
        $id = $request->id;

        $input = $request->all();
        $input['merchant_site_id'] = auth('web')->user()->id;

        $attributes = Attribute::find($id)->update($input);

        if($attributes){
            return redirect()->to('attribute/index')->withSuccess('Attribute update success');
        }
        return redirect()->back()->withSuccess('Attribute not update');
    }

    public function delete($id)
    {
        $attributes = Attribute::find($id);
        $attributes->delete();

        return redirect()->to('attribute/index')->withSuccess('Delete successfuly');
    }

}
