<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\Merchant;
use App\Models\MerchantSite;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

class RegisterController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Register Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users as well as their
    | validation and creation. By default this controller uses a trait to
    | provide this functionality without requiring any additional code.
    |
    */

    use RegistersUsers;

    /**
     * Where to redirect users after registration.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
    }

    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array  $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function validator(array $data)
    {
        return Validator::make($data, [
            'first_name' => ['required', 'string', 'max:255'],
            'last_name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'phone' => ['required', 'string', 'max:255'],
            'password' => ['required', 'string', 'min:8', 'confirmed'],
            'business_name' => '',
            'address' => '',
            'city' => '',
            'state' => '',
            'zip' => '',
            'business_type' => '',
            'document' => '',
            'title' => '',

        ]);
    }

    /**
     * Create a new user instance after a valid registration.
     *
     * @param  array  $data
     * @return \App\Models\Merchant
     */
    protected function create(array $data)
    {
        $merchant = Merchant::create([
            'first_name' => $data['first_name'],
            'last_name' => $data['last_name'],
            'email' => $data['email'],
            'phone' => $data['phone'],
            'password' => Hash::make($data['password']),
        ]);
        $merchantsites = MerchantSite::create([
            'merchant_id' => $merchant->id,
            'name' => $data['business_name'],
            'address' => $data['address'],
            'city' => $data['city'],
            'state' => $data['state'],
            'zip' => $data['zip'],
            'business_type' => $data['business_type'],
        ]);
        $merchant_site_documents1 = $merchantsites->merchantSiteDocument()->create([
            'title' => $data['title_business_liscense'],
            'document' => $data['business_liscense'],
        ]);
        $merchant_site_documents2 = $merchantsites->merchantSiteDocument()->create([
            'title' => $data['title_certificate'],
            'document' => $data['certificate'],
        ]);
        $merchant_site_documents3 = $merchantsites->merchantSiteDocument()->create([
            'title' => $data['title_identity'],
            'document' => $data['identity'],
        ]);

        return $merchant;
    }
}
