<?php

namespace App\Http\Controllers;

use App\Models\MerchantSite;
use Illuminate\Foundation\Auth\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class ChangePasswordController extends Controller
{
    public function create()
    {
        return view('setting.credential');
    }

    public function store(Request $request)
    {
        $this->validate($request, [
            'old_password' => 'required',
            'password' => 'required|confirmed',
            'password_confirmation' => 'required'
        ]);
    
        $user = MerchantSite::find(Auth::id());
        if (!Hash::check($request->old_password, $user->password)) {
          
            return redirect()->back()->withError('Current password does not match');
        }
    
        $user->password = Hash::make($request->password);
        $user->save();
        return redirect()->back()->withSuccess('Change Password Updated Successfully');
    }
}
