<?php

namespace App\Http\Controllers;

use App\Models\MenuType;
use App\Http\Helpers\Helper;
use App\Models\MerchantSite;
use Illuminate\Http\Request;

class MenuTypeController extends Controller
{
    /**
    * Get a menu type list
    * 
    * @return view
    */
    public function index()
    {
        $menutypes = MenuType::with('merchantSite')->orderBy('id', 'DESC')->paginate(10);

        return view('menutype.index', ['menutypes' => $menutypes]);
    }

    /**
    * Get a create view
    * 
    * @return view
    */
    public function create()
    {
        return view('menutype.create');
    }

    /**
    * Menu type create
    * 
    * @param $request
    * @return view
    */
    public function postCreate(Request $request)
    {
        $input = $request->all();

        $input['merchant_site_id'] = auth('web')->user()->id;
       
        MenuType::create($input);

        return redirect()->to('menutype/index')->withSuccess('Menu create sucessfuly');
    }

    /**
    * menu type edit by id
    * 
    * @param by id
    * @return view
    */
    public function edit($id)
    {
        $menutypes = MenuType::find($id);

        return view('menutype.edit', [ 'menutypes' => $menutypes]);
    }

    /**
    * menu type update by id
    * 
    * @param id
    * @param $request
    * @return view 
    */
    public function update(Request $request, $id)
    {
        $id = $request->id;

        $input = $request->all();

        $input['merchant_site_id'] = auth('web')->user()->id;

        MenuType::find($id)->update($input);

        return redirect()->to('menutype/index')->withSuccess('Menu updated successfully');
    }

    /**
    * Menu type delete by id 
    * 
    * @param id
    * @return view
    */
    public function delete($id)
    {
        $menutype = MenuType::find($id);
        $menutype->delete();

        return redirect()->to('menutype/index')->withSuccess('Delete successfully');
    }

    /**
    * Status update active and inactive
    * 
    * @param by id
    * @return View 
    */
    public function statusUpdate($id, Request $request)
    {
        $menutype = MenuType::find($id);
        $menutype->status = $request->status;
        $menutype->save();
  
        return response()->json(['data'=>'update successfully.']);
    }
}
