<?php

namespace App\Http\Controllers;

use App\Models\MerchantSite;
use Illuminate\Http\Request;

class MerchantSiteController extends Controller
{
    /**
     * Get merchant site 
     * 
     * @return view
     */
    public function index()
    {
        $merchants = MerchantSite::first();

        return view('merchant-site.index', ['merchants' => $merchants]);
    }


    /**
     * Get merchant edit view
     * 
     * @return view
     */
    public function edit()
    {
        $merchants = MerchantSite::first();

        return view('merchant-site.edit', ['merchants' => $merchants]);
    }

    /**
     * Merchant update
     * 
     * @param $request
     * @return redirect
     */
    public function update(Request $request)
    {
       $input = $request->all();

       if ($request->image) {
        // \Artisan::call('storage:link');
        \Storage::put('public/merchant_site/', $request->image );

        $input['image'] = $request->image->hashName();
        }

        if ($request->cover_image) {
            // \Artisan::call('storage:link');
            \Storage::put('public/merchant_site/', $request->cover_image );
    
            $input['cover_image'] = $request->cover_image->hashName();
        }

        $input['merchant_id'] = auth('web')->user()->id;

        $merchants = MerchantSite::updateOrCreate(
            [ 'merchant_id' => auth('web')->user()->id ],
            $input
        );

        if($merchants){

            return redirect()->to('merchant-site/index')->withSuccess('Updated merchant successfuly');
        }
        return redirect()->back()->withError('Merchant not update');
    }

     /**
    * is_online update on and off
    * 
    * @param by id
    * @return View 
    */
    public function toggleUpdate($id, Request $request)
    {
        $merchants = MerchantSite::find($id);
        $merchants->is_online = $request->is_online;
        $merchants->save();
  
        return response()->json(['data'=>'update successfully.']);
    }
}
