<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Menu extends Model
{
    use HasFactory, SoftDeletes;

    /**
    * The attributes that are mass assignable.
    *
    * @var string[]
    */
    protected $fillable = [
        'menu_type_id',
        'name', 
        'short_description', 
        'description',
        'ingridients',
        'calories',
        'allergies',
        'image',
        'variations',
        'choice_options',
        'price',
        'discount',
        'discount_type',
        'available_time_starts',
        'available_time_ends',
        'status'
    ];

    /**
    * Retrieve menu belongs to the menu type
    *
    * @return BelongsTo
    */
    public function menuType()
    {
        return $this->belongsTo(MenuType::class);
    }

    /**
    * Retrieve associated addons
    *
    * @return HasMany
    */
    public function addon()
    {
        return $this->hasMany(Addon::class);
    }

    /**
     * Retrieve associated menu  addon
     * 
     * @return HasMany
     */
    public function menuAddon()
    {
        return $this->hasMany(MenuAddon::class);
    }

    public function menuAttribute()
    {
        return $this->hasMany(MenuAttribute::class);
    }

    public function menuAttributeValue()
    {
        return $this->hasManyThrough(MenuAttributeValue::class, MenuAttribute::class,);
    }
}
