<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MenuType extends Model
{
    use HasFactory, SoftDeletes;

    /**
    * The attributes that are mass assignable.
    *
    * @var string[]
    */
    protected $fillable = [
        'merchant_site_id',
        'name',
        'position', 
        'status', 
    ];

    public function merchantSite()
    {
        return $this->belongsTo(MerchantSite::class);
    }
}
