<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCustomersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('customers', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('email')->unique();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            $table->string('phone');
            //forgot token
            $table->string('forgot_token')->nullable();
            $table->rememberToken();
            //is_medical_professional
            $table->boolean('is_medical_professional')->default(false);
            $table->string('document')->nullable();
            //is_active
            $table->boolean('is_active')->default(1);
            //last login
            $table->timestamp('last_login')->nullable();
            $table->timestamps();
            //softDeletes
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customers');
    }
}
