<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMenuAttributeValuesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('menu_attribute_values', function (Blueprint $table) {
            $table->id();
            $table->foreignId('menu_attribute_id')
                ->constrained('menu_attributes')
                ->onDelete('cascade');
            $table->text('description');
            $table->decimal('price');    
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('menu_attribute_values');
    }
}
