@extends('layouts.master')

@section('pagetitle')
Dashboard
@endsection
@section('title')
Dashboard
@endsection

@section('content')

<meta name="csrf-token" content="{{ csrf_token() }}">
<div class="card">
            <div class="card-body"> 
            @include('layouts.alert') 
                <a href="{{ url('addon/create') }}"
                    class="btn btn-success btn-flat"> 
                    <i class="icon-plus" aria-hidden="true"> Add Addons</i>
                </a>
                    <hr>
                <h4 class="card-title"> Addon List </h4>
                  <div class="table-responsive">
                    <table class="table table-hover color-table ">
                        <thead>
                            <tr>
                                <th>S.no</th>
                                <th>Name</th>
                                <th>price</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($addons as $addon)
                            <tr>
                            <td>{{ $addon->id }}</td>
                            <td>{{ $addon->name }}</td>
                            <td>{{ $addon->price }}</td>
                            <td>
                                <a href="{{ url('addon/'.$addon->id.'/edit') }}"
                                    class="btn btn-dropbox btn-flat btn-sm"> 
                                    <i class="icon-pencil" aria-hidden="true"></i>
                                </a>
                                <a href="{{ url('addon/'.$addon->id.'/delete') }}"
                                    class="btn btn-danger btn-flat btn-sm"> 
                                    <i class="icon-close" aria-hidden="true"></i>
                                </a>      
                            </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                    {{ $addons->links() }}
                   
                </div>
            </div>
    </div>

@endsection
@section('script')

@endsection