@extends('layouts.master')

@section('pagetitle')
Dashboard
@endsection
@section('title')
Dashboard
@endsection

@section('content')

<div class="card">
    <div class="card-body">
        <!-- Nav tabs -->
        <form action="{{  url('menu/'.$menus->id.'/update') }}" method="POST" enctype="multipart/form-data">
            @csrf
            
            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input">Menu Type*</label>
                <div class="col-10">
                <select name="menu_type_id" class="form-control">
                <option value="">Select Menu Type</option>
   
                    @foreach($menutypes as $m )
                    <option value="{{ $m->id }}"  {{ $m->id == @$menus['menu_type_id'] ? "selected" : "" }}>
                         {{ ucfirst($m->name) }} </option>
                    @endforeach
                </select>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input">Name*</label>
                <div class="col-10">
                <input type="text" name="name" value="{{ $menus->name }}" class="form-control" autocomplete="off" placeholder=" Name" required>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input"> Short Description*</label>
                    <div class="col-10">
                    <textarea class="ckeditor" rows="25" cols="15" id="short_description" name="short_description"> {{ $menus->short_description }} </textarea>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input"> Description*</label>
                    <div class="col-10">
                    <textarea class="ckeditor" rows="25" cols="15" id="description" name="description"> {{ $menus->description }} </textarea>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input"> Ingridients*</label>
                    <div class="col-10">
                    <textarea class="ckeditor" rows="25" cols="15" id="ingridients" name="ingridients"> {{ $menus->ingridients }} </textarea>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input"> Calories*</label>
                    <div class="col-10">
                    <textarea class="ckeditor" rows="25" cols="15" id="calories" name="calories"> {{ $menus->calories }} </textarea>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input"> Allergies*</label>
                    <div class="col-10">
                    <textarea class="ckeditor" rows="25" cols="15" id="allergies" name="allergies"> {{ $menus->allergies }} </textarea>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input">Addon*</label>
                <div class="col-10">
                <select class="select2 m-b-10 select2-multiple" name="addon_id[]" style="width: 100%" multiple="multiple" data-placeholder="Choose" id="addon-options">
                @foreach($addons as $a )
                    <option value="{{ $a->id }}" {{ in_array( $a->id , $menus->addons) ? "selected" : "" }}>{{ ucfirst($a->name) }}</option>
                @endforeach 
                </select>
                </div>  
            </div>

            <div class="border mb-4 p-2">
                <div class="form-group">
                    <label class="col-2 col-form-label" for="example-color-input"> Attribute*</label>
                    <div class="">
                    <select class="select2 m-b-10 select2-multiple" name="attribute_id[]" style="width: 100%" multiple="multiple" data-placeholder="Choose" id="attr-options">
                    @foreach($attributes as $at )
                        <option value="{{ $at->id }}" {{ in_array( $at->id , $menus->attributes) ? "selected" : "" }} >{{ ucfirst($at->name) }}</option>
                    @endforeach 
                    </select>
                </div>  
                </div>
                
                <div id="option-values">
                    @foreach($menus->menuAttribute as $ma)
                  
                    <div class="mb-4 p-2" id="{{ $ma->option->name }}-{{$ma->option->id}}" >
                        <div>
                            <label>{{ $ma->option->name }}</label>
                            <button onclick="addRow('#{{ $ma->option->name }}-{{$ma->option->id}}', {{ $ma->option->id }})" class="btn btn-warning btn-sm"  type="button"><i class="icon-plus"></i></button>
                        </div>

                        @foreach($ma->attributeValues as $key => $av)
                        <div class="row mb-2">
                            <div class="col-sm-4">
                                <input type="hidden" name="attribute[{{ $ma->option->id }}][{{ $key }}][id]" value="{{ $av->id }}">
                                <input type="hidden" name="attribute[{{ $ma->option->id }}][{{ $key }}][attribute_id]" value="${{ $ma->option->id }}">
                                <input type="text" name="attribute[{{ $ma->option->id }}][{{ $key }}][description]" value="{{ @$av->description }}" class="form-control" placeholder="Option">
                            </div>
                            <div class="col-sm-4">
                                <input type="number" name="attribute[{{ $ma->option->id }}][{{ $key }}][price]" value="{{ @$av->price }}" class="form-control" placeholder="Price">
                            </div>
                            <div class="col-sm-4">
                                <button type="button" onclick="removeRow(this)" class="btn btn-danger"><i class="ti-trash"></i></button>
                            </div>
                        </div>
                        @endforeach
                    </div>
                    @endforeach
                </div>
            </div>

            <div class="form-group row">
                <label  class="col-2 col-form-label" for="example-color-input"> Price*</label>
                <div class="col-10">
                <input type="text" name="price" value="{{ $menus->price }}" autocomplete="off" class="form-control">
                </div>
            </div> 

            <div class="form-group row">
                <label  class="col-2 col-form-label" for="example-color-input"> Discount*</label>
                <div class="col-10">
                <input type="text" name="discount" value="{{ $menus->discount }}" autocomplete="off" class="form-control">
                </div>
            </div> 

            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input"> Discount Type*</label>
                <div class="col-10">
                <select name="discount_type"  class="form-control">
                <option value="" >Select Menu Type</option>
                    <option value="{{ $menus->discount_type }} " selected>Percent</option>
                    <option value="{{ $menus->discount_type }}" selected>Amount</option>
                </select>
                </div> 
            </div> 

            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input"> Time Starts*</label>
                <div class="col-10">
                <input type="time" name="available_time_starts" value="{{ $menus->available_time_starts }}" autocomplete="off" class="form-control">
                </div>  
            </div> 

            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input"> Time Ends*</label>
                <div class="col-10"> 
                <input type="time" name="available_time_ends" value="{{ $menus->available_time_ends }}" autocomplete="off" class="form-control">
                </div>
            </div> 
            
            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input"> Image*</label> 
                <img src="{{ url('storage/'.$menus->image ) }}" style="width:150px; height:150px;">
                <div class="col-10">
                <input type="file" name="image" class="form-control">
                </div> 
            </div> 

            <div class="mt-2 text-right">
                <button class="btn btn-warning">Save</button>
            </div>
        </form>
    </div>
</div>

@endsection

@section('script')

<script>
    CKEDITOR.editorConfig = function(config) {
        config.language = 'es';
        config.uiColor = '#F7B42C';
        config.height = 2000;
        config.toolbarCanCollapse = true;
    };


    $(document).ready(function() {
        $("#addon-options").select2();
        $("#attr-options").select2();
    });
    // // $("#addon-options").select2();
    // $("#attr-options").select2();
    
    $('#attr-options').on('select2:unselecting', function (e) {
        var data = e.params.args.data;
        console.log(data, e);

        $(`#${ data.text }-${ data.id }`).remove()

    });

    $('#attr-options').on('select2:select', function (e) {
        var data = e.params.data;
        console.log(data);

        $("#option-values").append( `
            <div class="mb-4 p-2" id="${ data.text +"-"+ data.id  }" >
                <div>
                    <label>${ data.text }</label>
                    <button onclick="addRow('#${ data.text +"-"+ data.id  }', ${data.id})" class="btn btn-warning btn-sm"  type="button"><i class="icon-plus"></i></button>
                </div>
                <div class="row mb-2">
                    <div class="col-sm-4">
                        <input type="text" name="attribute[${data.id}][0][description]" class="form-control" placeholder="Option">
                    </div>
                    <div class="col-sm-4">
                        <input type="number" name="attribute[${data.id}][0][price]" class="form-control" placeholder="Price">
                    </div>
                    <div class="col-sm-4">
                        <button type="button" onclick="removeRow(this)" class="btn btn-danger"><i class="ti-trash"></i></button>
                    </div>
                </div>
            </div>` );
    });

    function addRow(elem, id){

        var index = $(elem).find('.row').length;

        $(elem).append(`
        <div class="row mb-2">
            <div class="col-sm-4">
                <input type="text" name="attribute[${ id }][${index}][description]" class="form-control" placeholder="Option">
            </div>
            <div class="col-sm-4">
                <input type="number" name="attribute[${ id }][${index}][price]" class="form-control" placeholder="Price">
            </div>
            <div class="col-sm-4">
                <button type="button" onclick="removeRow(this)" class="btn btn-danger"><i class="ti-trash"></i></button>
            </div>
        </div>`);
    }

    function removeRow(elem){
        $(elem).parent().parent().remove();
        // $(elem)
    }

</script>
@endsection