@extends('layouts.master')

@section('pagetitle')
Dashboard
@endsection
@section('title')
Dashboard
@endsection

@section('content')

<div class="card">
    <div class="card-body">
        <!-- Nav tabs -->
        <form action="{{  url('merchant-site/'.$merchants->id.'/update') }}" method="POST" enctype="multipart/form-data">
            @csrf

            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input">Name*</label>
                <div class="col-10">
                <input type="text" name="name" value="{{ $merchants->name }}" class="form-control" autocomplete="off" placeholder=" Name" required>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input"> Site Status*</label>
                <div class="col-10">

                <select name="site_status" class="form-control">
                <option value="">Select Status</option>
                <option value="{{ $merchants->site_status }} " selected> Pending </option>
                <option value="{{ $merchants->site_status }} " selected> Active </option>
                <option value="{{ $merchants->site_status }} " selected> Suspended </option>
                </select>

                </div>
            </div>

            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input"> Phone*</label>
                    <div class="col-10">
                    <input type="text" name="phone" value="{{ $merchants->phone }}" class="form-control" autocomplete="off" placeholder=" phone" required>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input"> Address*</label>
                    <div class="col-10">
                    <input type="text" name="address" value="{{ $merchants->address }}" class="form-control" autocomplete="off" placeholder=" address" required>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input"> City*</label>
                    <div class="col-10">
                    <input type="text" name="city" value="{{ $merchants->city }}" class="form-control" autocomplete="off" placeholder=" city" required>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input"> State*</label>
                    <div class="col-10">
                    <input type="text" name="state" value="{{ $merchants->state }}" class="form-control" autocomplete="off" placeholder=" state" required>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input"> Zip*</label>
                    <div class="col-10">
                    <input type="text" name="zip" value="{{ $merchants->zip }}" class="form-control" autocomplete="off" placeholder=" zip" required>
                </div>
            </div>

            <div class="form-group row">
                <label  class="col-2 col-form-label" for="example-color-input"> Country*</label>
                <div class="col-10">
                <input type="text" name="country" value="{{ $merchants->country }}" autocomplete="off" class="form-control">
                </div>
            </div>

            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input"> Business Type*</label>
                <div class="col-10">
                <select name="discount_type"  class="form-control">
                <option value="" >Select Menu Type</option>
                    <option value="{{ $merchants->business_type }} " selected>Restaurant</option>
                    <option value="{{ $merchants->business_type }}" selected>Grocery</option>
                </select>
                </div> 
            </div> 
            
            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input"> Image*</label> 
                <img src="{{ url('storage/merchant_site/'.$merchants->image ) }}" style="width:150px; height:150px;">
                <div class="col-7">
                <input type="file" name="image" class="form-control">
                </div> 
            </div> 

            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input"> Cover Image*</label> 
                <img src="{{ url('storage/merchant_site/'.$merchants->cover_image ) }}" style="max-height: 250px; overflow-y: hidden;">
                <div class="col-4">
                <input type="file" name="cover_image" class="form-control">
                </div> 
            </div>

            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input"> Minimum Order Amount*</label>
                <div class="col-10">
                <input type="text" name="min_order_amount" value="{{ $merchants->min_order_amount }}" autocomplete="off" class="form-control">
                </div>  
            </div> 

            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input"> Minimum Cook Time*</label>
                <div class="col-10"> 
                <input type="time" name="min_cook_time" value="{{ $merchants->min_cook_time }}" autocomplete="off" class="form-control">
                </div>
            </div> 

            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input"> Price Range*</label>
                <div class="col-10"> 
                    
                <select name="price_range"  class="form-control">  
                <option value="" >Select Price Range</option>
                    <option value="{{ $merchants->price_range }} " selected>$</option>
                    <option value="{{ $merchants->price_range }}" selected>$$</option>
                    <option value="{{ $merchants->price_range }}" selected>$$$</option>
                </select>
  
                </div>
            </div> 

            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input"> Food Type*</label>
                <div class="col-10"> 
                <input type="text" name="food_type" value="{{ $merchants->food_type }}" autocomplete="off" class="form-control">
                </div>
            </div> 

            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input"> Description*</label>
                    <div class="col-10">
                    <textarea class="ckeditor" rows="25" cols="15" id="description" name="description"> {{ $merchants->description }} </textarea>
                </div>
            </div>

            <div class="mt-2 text-right">
                <button class="btn btn-warning">Save</button>
            </div>
        </form>
    </div>
</div>

@endsection

@section('script')

<script>
    CKEDITOR.editorConfig = function(config) {
        config.language = 'es';
        config.uiColor = '#F7B42C';
        config.height = 2000;
        config.toolbarCanCollapse = true;
    };

</script>
@endsection