@extends('layouts.master')

@section('pagetitle')
Dashboard
@endsection
@section('title')
Dashboard
@endsection

@section('content')

<div class="card">
    <div class="card-body">
    @include('layouts.alert')
        <h5 class="card-title">Change Password</h5>
        <hr>
        <!-- Nav tabs -->
        <form action="{{ url('setting/store') }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PATCH')

            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input"> Current Password*</label>
                <div class="col-10">
                <input type="password" name="old_password" class="form-control {{ $errors->has('old_password') ? 'is-invalid' : '' }}" autocomplete="off" placeholder=" Current Password" required>
                @error('old_password')
                    <div class="invalid-feedback">
                        {{ $message }}
                    </div>
                @enderror
                </div>
            </div>

            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input">New Password*</label>
                <div class="col-10">
                <input type="password" name="password" class="form-control  {{ $errors->has('password') ? 'is-invalid' : '' }} " autocomplete="off" placeholder=" New Password" required>
                @error('password')
                    <div class="invalid-feedback">
                        {{ $message }}
                    </div>
                @enderror
                </div>
            </div>

            <div class="form-group row">
                <label class="col-2 col-form-label" for="example-color-input"> Confirm  Password*</label>
                <div class="col-10">
                <input type="password" name="password_confirmation" class="form-control {{ $errors->has('password_confirmation') ? 'is-invalid' : '' }}" autocomplete="off" placeholder=" Confirm Password" required>
                @error('password_confirmation')
                    <div class="invalid-feedback">
                        {{ $message }}
                    </div>
                @enderror
                </div>
            </div>

            <div class="mt-2 text-right">
                 <button type="submit" class="btn btn-warning waves-effect waves-light m-r-10">Submit</button>
            </div>
        </form>
    </div>
</div>

@endsection